#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Naive Shaded HelixMod01.fsh   by  sylvain69780 
//https://www.shadertoy.com/view/3lVfRy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
    Naive Shaded Helix
    ------------------
    
    A try to get a decent SDF and domain repetition for an helix.
    And very cool paradoxical speed effect (Thanks Fabrice)
    
    Related references
    
    RayMarching starting point - BigWIngs
    https://shadertoy.com/view/WtGXDD

    Quick Lighting Tech - blackle 
    https://www.shadertoy.com/view/ttGfz1
    
    soft shadows in raymarched SDFs - IQ
    https://iquilezles.org/articles/rmshadows

*/

// Play with this !
#define CYLINDER_RAD      2.3+sin(T)
#define CYLINDER_SPACING  0.1
#define CORE_SIZE         vec2(.1,.3)
#define CYLINDER2_RAD     .4
#define CYLINDER2_SPACING 0.0
#define CORE2_SIZE        vec2(.1,.25)
#define SPEED             3.14


// Classical 
#define MAX_STEPS 200
#define MAX_DIST 10.
#define SURF_DIST .001
#define S smoothstep
#define T iTime*.3
#define TAU 6.283185
 
// a flat band of 1 unit wide, wound around an infinite cylinder of radius r
// with UV parameters
vec3 wrappedCylinder(vec3 p, float r) 
{
    p.y-=-.5; // center the starting point at y=zero
    float tpr = atan(p.z, p.x);
    float tp = tpr/TAU;
    float turn = p.y-tp;      // counting the turns
    float count=floor(turn);
    float delta=fract(turn);
    float ts=tp+count;
    float u=ts*r*TAU;
    float v=delta-.5; // from -.5 to .5
    // fix orientation regarding the slope
     float slope = 1.0/(TAU*r);
     u+=v*slope/sqrt(1.0+slope*slope); // sin(atan(x)) = x/sqrt(x2+1)
     // distance calculation
    float d = length(p.xz) - r;
    return vec3(d,u,v);
}

float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,0.0)) + min(max(d.x,d.y),0.0);
}

vec4 ribbon(vec3 p, float r, float spacing, vec2 thickness, float rounding)
{
    float scale=spacing+1.0;
    vec3 duv = scale*wrappedCylinder(p/scale,r/scale); // I wonder how well distances are preserved
    float w=duv.x;
    vec2 uv=duv.yz;
    vec2 q=duv.xz;
    float d=sdBox(q,thickness*.5)-rounding;
    return vec4(d,uv,w);
}

mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float GetDist(vec3 p) {  	
    vec4 duvw =  ribbon(p,CYLINDER_RAD,CYLINDER_SPACING,CORE_SIZE,.03);
    vec3 p2=duvw.zyw;
    p2.y+=T*SPEED;
    vec4 duvw2 = ribbon(p2,CYLINDER2_RAD,CYLINDER2_SPACING,CORE2_SIZE,.05);
    float d=min(duvw.x,duvw2.x);
    return d;
}

float RayMarch(vec3 ro, vec3 rd) {
	float dO=0.;
    
    for(int i=0; i<MAX_STEPS; i++) {
    	vec3 p = ro + rd*dO;
        float dS = GetDist(p);
        dO += dS;
        if(dO>MAX_DIST || abs(dS)<SURF_DIST) break;
    }
    return dO;
}

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p), // forward vector
        r = normalize(cross(f,vec3(0,1,0) )),   // right vector
        u = cross(r,f),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}

// Inigo

float calcOcclusion( in vec3 pos, in vec3 nor )
{
	float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float h = 0.01 + 0.33*float(i)/4.0;
        vec3 opos = pos + h*nor;
        float d = GetDist( opos );
        occ += (h-d)*sca;
        sca *= 0.95;
    }
    return clamp( 1.0 - 2.0*occ, 0.0, 1.0 );
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
	vec2 m = vec2(0);
    
    vec3 ro = vec3(0, 1, 5);
    vec3 ta = vec3(0,0,0);
    if ( iMouse.x > 0.0 ) {
        m=2.0*iMouse.xy/iResolution.xy-1.0;
        ro.yz *= Rot(-m.y*3.14);
        ro.xz *= Rot(-m.x*6.2831);
    }
    vec3 rd = GetRayDir(uv, ro, ta, 1.);
    float d = RayMarch(ro, rd);
    
    vec3 col,bg = vec3(.1)/(1.0+3.0*abs(rd.y)); 
    if(d<MAX_DIST) {
    	vec3 p = ro + rd * d;
    	vec3 n = GetNormal(p);
        float occ = calcOcclusion(p,n);
        // Blackle https://www.shadertoy.com/view/ttGfz1
        float dif= pow(length(sin(n*3.)*.5+.5)/sqrt(3.), 4.);
    	float lin = dif*occ;
        col = vec3(1.2) * lin;
        // fog
        float fogAmount = 1.0 - exp( -max(0.0,d-3.0)*.3 );
        col = mix(col, bg,fogAmount);
    } else {
        col = bg;
    }
    col = sqrt(col);	// gamma correction
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

